/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.custom.OldTrellisBlock;
import net.hecco.bountifulfares.trellis.BFTrellises;
import net.hecco.bountifulfares.trellis.TrellisUtil;
import net.hecco.bountifulfares.trellis.trellis_parts.DecorativeVine;
import net.hecco.bountifulfares.trellis.trellis_parts.TrellisVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class DecorativeTrellisBlock
extends OldTrellisBlock
implements BonemealableBlock {
    private final boolean canDuplicate;
    public TrellisVariant variant;
    public DecorativeVine vine;

    public DecorativeTrellisBlock(boolean canDuplicate, Item item, TrellisVariant variant, DecorativeVine vine, BlockBehaviour.Properties settings) {
        super(settings);
        this.canDuplicate = canDuplicate;
        BFBlocks.PLANTS_TO_DECORATIVE_TRELLISES.put(item, this);
        BFBlocks.DECORATIVE_TRELLISES_TO_PLANTS.put(this, item);
        this.variant = variant;
        this.vine = vine;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, f_54117_});
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        if (player.m_21120_(hand).m_150930_(Items.f_42574_)) {
            player.m_21120_(hand).m_41622_(1, (LivingEntity)player, playerx -> playerx.m_21190_(hand));
            world.m_7731_(pos, (BlockState)TrellisUtil.getTrellisFromVariant(this.variant).m_49966_().m_61124_((Property)f_54117_, (Comparable)facing), 2);
            DecorativeTrellisBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFBlocks.DECORATIVE_TRELLISES_TO_PLANTS.get((Object)this)));
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!player.m_7500_()) {
            DecorativeTrellisBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.vine.getPlantItem()));
        }
        super.m_5707_(world, pos, state, player);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)TrellisUtil.getTrellisFromVariant(this.variant));
    }

    public boolean m_7370_(LevelReader world, BlockPos pos, BlockState state, boolean isClient) {
        return this.canDuplicate;
    }

    public boolean m_214167_(Level world, RandomSource random, BlockPos pos, BlockState state) {
        return this.canDuplicate;
    }

    public void m_214148_(ServerLevel world, RandomSource random, BlockPos pos, BlockState state) {
        if (this.canDuplicate) {
            DecorativeTrellisBlock.m_49840_((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)BFBlocks.DECORATIVE_TRELLISES_TO_PLANTS.get((Object)this)));
        }
    }

    public static BlockState getDecorativeTrellisFromPlant(Item item) {
        if (item != null && BFBlocks.PLANTS_TO_DECORATIVE_TRELLISES.containsKey(item)) {
            return BFBlocks.PLANTS_TO_DECORATIVE_TRELLISES.get(item).m_49966_();
        }
        return BFTrellises.TRELLISES.get("trellis").m_49966_();
    }
}

